// المنتجات
const products = [
    {name: 'تفاح', price: 5, category: 'فاكهة', img: 'https://via.placeholder.com/150.png?text=تفاح'},
    {name: 'موز', price: 3, category: 'فاكهة', img: 'https://via.placeholder.com/150.png?text=موز'},
    {name: 'خيار', price: 2, category: 'خضار', img: 'https://via.placeholder.com/150.png?text=خيار'},
    {name: 'طماطم', price: 4, category: 'خضار', img: 'https://via.placeholder.com/150.png?text=طماطم'},
    {name: 'عصير برتقال', price: 6, category: 'مشروبات', img: 'https://via.placeholder.com/150.png?text=عصير+برتقال'},
    {name: 'مياه', price: 1, category: 'مشروبات', img: 'https://via.placeholder.com/150.png?text=مياه'}
];

let cart = [];

// عرض المنتجات
function displayProducts(filter = 'all') {
    const productList = document.querySelector('.product-list');
    productList.innerHTML = '';
    const filtered = filter === 'all' ? products : products.filter(p => p.category === filter);
    filtered.forEach(product => {
        const div = document.createElement('div');
        div.className = 'product';
        div.innerHTML = `
            <img src="${product.img}" alt="${product.name}">
            <h3>${product.name}</h3>
            <p>السعر: $${product.price}</p>
            <button class="add" onclick="addToCart('${product.name}', ${product.price})">أضف إلى السلة</button>
        `;
        productList.appendChild(div);
    });
}

// تصفية حسب الفئة
function filterCategory(category) {
    displayProducts(category);
}

// إضافة إلى السلة
function addToCart(name, price) {
    const existing = cart.find(item => item.name === name);
    if (existing) {
        existing.quantity++;
    } else {
        cart.push({name, price, quantity: 1});
    }
    updateCart();
}

// إزالة من السلة
function removeFromCart(name) {
    cart = cart.filter(item => item.name !== name);
    updateCart();
}

// تحديث السلة
function updateCart() {
    const cartItems = document.getElementById('cart-items');
    const total = document.getElementById('total');
    const checkoutTotal = document.getElementById('checkout-total');
    cartItems.innerHTML = '';
    let sum = 0;

    cart.forEach(item => {
        sum += item.price * item.quantity;
        const li = document.createElement('li');
        li.textContent = `${item.name} - $${item.price} × ${item.quantity} `;
        const removeBtn = document.createElement('button');
        removeBtn.textContent = 'حذف';
        removeBtn.className = 'remove';
        removeBtn.onclick = () => removeFromCart(item.name);
        li.appendChild(removeBtn);
        cartItems.appendChild(li);
    });

    total.textContent = sum;
    checkoutTotal.textContent = sum;
}

// Checkout وهمي
function checkout() {
    if(cart.length === 0){
        document.getElementById('checkout-message').textContent = 'السلة فارغة!';
        return;
    }
    document.getElementById('checkout-message').textContent = 'تم تأكيد الطلب! شكراً لتسوقك معنا 😊';
    cart = [];
    updateCart();
}

// تسجيل دخول وهمي
document.getElementById('loginForm').addEventListener('submit', function(e){
    e.preventDefault();
    const username = document.getElementById('username').value;
    document.getElementById('loginMessage').textContent = `مرحبا، ${username}! لقد تم تسجيل الدخول بنجاح.`;
    document.getElementById('loginForm').reset();
});

// عرض جميع المنتجات عند تحميل الصفحة
displayProducts();
